package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GrpcConfig(enabled: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GrpcConfig = {
    import GrpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GrpcConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GrpcConfig.ReadOnly =
    zio.aws.cloudfront.model.GrpcConfig.wrap(buildAwsValue())
}
object GrpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GrpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GrpcConfig =
      zio.aws.cloudfront.model.GrpcConfig(enabled)
    def enabled: Boolean
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GrpcConfig
  ) extends zio.aws.cloudfront.model.GrpcConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GrpcConfig
  ): zio.aws.cloudfront.model.GrpcConfig.ReadOnly = new Wrapper(impl)
}
