package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FunctionConfig(
    comment: String,
    runtime: zio.aws.cloudfront.model.FunctionRuntime,
    keyValueStoreAssociations: Optional[
      zio.aws.cloudfront.model.KeyValueStoreAssociations
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FunctionConfig = {
    import FunctionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FunctionConfig
      .builder()
      .comment(comment: java.lang.String)
      .runtime(runtime.unwrap)
      .optionallyWith(
        keyValueStoreAssociations.map(value => value.buildAwsValue())
      )(_.keyValueStoreAssociations)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FunctionConfig.ReadOnly =
    zio.aws.cloudfront.model.FunctionConfig.wrap(buildAwsValue())
}
object FunctionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FunctionConfig =
      zio.aws.cloudfront.model.FunctionConfig(
        comment,
        runtime,
        keyValueStoreAssociations.map(value => value.asEditable)
      )
    def comment: String
    def runtime: zio.aws.cloudfront.model.FunctionRuntime
    def keyValueStoreAssociations
        : Optional[zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly]
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
    def getRuntime
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FunctionRuntime] =
      ZIO.succeed(runtime)
    def getKeyValueStoreAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly
    ] = AwsError.unwrapOptionField(
      "keyValueStoreAssociations",
      keyValueStoreAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ) extends zio.aws.cloudfront.model.FunctionConfig.ReadOnly {
    override val comment: String = impl.comment(): String
    override val runtime: zio.aws.cloudfront.model.FunctionRuntime =
      zio.aws.cloudfront.model.FunctionRuntime.wrap(impl.runtime())
    override val keyValueStoreAssociations: Optional[
      zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keyValueStoreAssociations())
      .map(value =>
        zio.aws.cloudfront.model.KeyValueStoreAssociations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionConfig
  ): zio.aws.cloudfront.model.FunctionConfig.ReadOnly = new Wrapper(impl)
}
