package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.DomainStatus
  ): zio.aws.cloudfront.model.DomainStatus = value match {
    case software.amazon.awssdk.services.cloudfront.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.DomainStatus.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.cloudfront.model.DomainStatus.INACTIVE =>
      val r = inactive
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DomainStatus =
      software.amazon.awssdk.services.cloudfront.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.cloudfront.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DomainStatus =
      software.amazon.awssdk.services.cloudfront.model.DomainStatus.ACTIVE
  }
  case object inactive extends zio.aws.cloudfront.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DomainStatus =
      software.amazon.awssdk.services.cloudfront.model.DomainStatus.INACTIVE
  }
}
