package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DomainConflict(
    domain: String,
    resourceType: zio.aws.cloudfront.model.DistributionResourceType,
    resourceId: String,
    accountId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DomainConflict = {
    import DomainConflict.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DomainConflict
      .builder()
      .domain(domain: java.lang.String)
      .resourceType(resourceType.unwrap)
      .resourceId(resourceId: java.lang.String)
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DomainConflict.ReadOnly =
    zio.aws.cloudfront.model.DomainConflict.wrap(buildAwsValue())
}
object DomainConflict {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DomainConflict
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DomainConflict =
      zio.aws.cloudfront.model.DomainConflict(
        domain,
        resourceType,
        resourceId,
        accountId
      )
    def domain: String
    def resourceType: zio.aws.cloudfront.model.DistributionResourceType
    def resourceId: String
    def accountId: String
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.DistributionResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainConflict
  ) extends zio.aws.cloudfront.model.DomainConflict.ReadOnly {
    override val domain: String = impl.domain(): String
    override val resourceType
        : zio.aws.cloudfront.model.DistributionResourceType =
      zio.aws.cloudfront.model.DistributionResourceType
        .wrap(impl.resourceType())
    override val resourceId: String = impl.resourceId(): String
    override val accountId: String = impl.accountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainConflict
  ): zio.aws.cloudfront.model.DomainConflict.ReadOnly = new Wrapper(impl)
}
