package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateDistributionTenantWebAclRequest(
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclRequest = {
    import DisassociateDistributionTenantWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest.ReadOnly =
    zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest
      .wrap(buildAwsValue())
}
object DisassociateDistributionTenantWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest =
      zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest(
        id,
        ifMatch.map(value => value)
      )
    def id: String
    def ifMatch: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclRequest
  ) extends zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclRequest
  ): zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclRequest.ReadOnly =
    new Wrapper(impl)
}
