package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.FunctionName
import scala.jdk.CollectionConverters._
final case class DeleteFunctionRequest(name: FunctionName, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest = {
    import DeleteFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteFunctionRequest.wrap(buildAwsValue())
}
object DeleteFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteFunctionRequest =
      zio.aws.cloudfront.model.DeleteFunctionRequest(name, ifMatch)
    def name: FunctionName
    def ifMatch: String
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ) extends zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest
  ): zio.aws.cloudfront.model.DeleteFunctionRequest.ReadOnly = new Wrapper(impl)
}
