package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDistributionTenantRequest(id: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteDistributionTenantRequest = {
    import DeleteDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteDistributionTenantRequest
      .builder()
      .id(id: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteDistributionTenantRequest
      .wrap(buildAwsValue())
}
object DeleteDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteDistributionTenantRequest =
      zio.aws.cloudfront.model.DeleteDistributionTenantRequest(id, ifMatch)
    def id: String
    def ifMatch: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.DeleteDistributionTenantRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteDistributionTenantRequest
  ): zio.aws.cloudfront.model.DeleteDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
