package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Customizations(
    webAcl: Optional[zio.aws.cloudfront.model.WebAclCustomization] =
      Optional.Absent,
    certificate: Optional[zio.aws.cloudfront.model.Certificate] =
      Optional.Absent,
    geoRestrictions: Optional[
      zio.aws.cloudfront.model.GeoRestrictionCustomization
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Customizations = {
    import Customizations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Customizations
      .builder()
      .optionallyWith(webAcl.map(value => value.buildAwsValue()))(_.webAcl)
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(geoRestrictions.map(value => value.buildAwsValue()))(
        _.geoRestrictions
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Customizations.ReadOnly =
    zio.aws.cloudfront.model.Customizations.wrap(buildAwsValue())
}
object Customizations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Customizations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Customizations =
      zio.aws.cloudfront.model.Customizations(
        webAcl.map(value => value.asEditable),
        certificate.map(value => value.asEditable),
        geoRestrictions.map(value => value.asEditable)
      )
    def webAcl: Optional[zio.aws.cloudfront.model.WebAclCustomization.ReadOnly]
    def certificate: Optional[zio.aws.cloudfront.model.Certificate.ReadOnly]
    def geoRestrictions: Optional[
      zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly
    ]
    def getWebAcl: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.WebAclCustomization.ReadOnly
    ] = AwsError.unwrapOptionField("webAcl", webAcl)
    def getCertificate
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getGeoRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly
    ] = AwsError.unwrapOptionField("geoRestrictions", geoRestrictions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Customizations
  ) extends zio.aws.cloudfront.model.Customizations.ReadOnly {
    override val webAcl
        : Optional[zio.aws.cloudfront.model.WebAclCustomization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webAcl())
        .map(value => zio.aws.cloudfront.model.WebAclCustomization.wrap(value))
    override val certificate
        : Optional[zio.aws.cloudfront.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.cloudfront.model.Certificate.wrap(value))
    override val geoRestrictions: Optional[
      zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.geoRestrictions())
      .map(value =>
        zio.aws.cloudfront.model.GeoRestrictionCustomization.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Customizations
  ): zio.aws.cloudfront.model.Customizations.ReadOnly = new Wrapper(impl)
}
