package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyDnsConfigurationResponse(
    dnsConfigurationList: Optional[
      Iterable[zio.aws.cloudfront.model.DnsConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationResponse = {
    import VerifyDnsConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationResponse
      .builder()
      .optionallyWith(
        dnsConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dnsConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.VerifyDnsConfigurationResponse.ReadOnly =
    zio.aws.cloudfront.model.VerifyDnsConfigurationResponse
      .wrap(buildAwsValue())
}
object VerifyDnsConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VerifyDnsConfigurationResponse =
      zio.aws.cloudfront.model.VerifyDnsConfigurationResponse(
        dnsConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dnsConfigurationList
        : Optional[List[zio.aws.cloudfront.model.DnsConfiguration.ReadOnly]]
    def getDnsConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.DnsConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("dnsConfigurationList", dnsConfigurationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationResponse
  ) extends zio.aws.cloudfront.model.VerifyDnsConfigurationResponse.ReadOnly {
    override val dnsConfigurationList
        : Optional[List[zio.aws.cloudfront.model.DnsConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsConfigurationList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.DnsConfiguration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationResponse
  ): zio.aws.cloudfront.model.VerifyDnsConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
