package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyDnsConfigurationRequest(
    domain: Optional[String] = Optional.Absent,
    identifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationRequest = {
    import VerifyDnsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationRequest
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .identifier(identifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.VerifyDnsConfigurationRequest.ReadOnly =
    zio.aws.cloudfront.model.VerifyDnsConfigurationRequest.wrap(buildAwsValue())
}
object VerifyDnsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VerifyDnsConfigurationRequest =
      zio.aws.cloudfront.model
        .VerifyDnsConfigurationRequest(domain.map(value => value), identifier)
    def domain: Optional[String]
    def identifier: String
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationRequest
  ) extends zio.aws.cloudfront.model.VerifyDnsConfigurationRequest.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val identifier: String = impl.identifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VerifyDnsConfigurationRequest
  ): zio.aws.cloudfront.model.VerifyDnsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
