package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.ParameterName
import scala.jdk.CollectionConverters._
final case class ParameterDefinition(
    name: ParameterName,
    definition: zio.aws.cloudfront.model.ParameterDefinitionSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ParameterDefinition = {
    import ParameterDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ParameterDefinition
      .builder()
      .name(ParameterName.unwrap(name): java.lang.String)
      .definition(definition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ParameterDefinition.ReadOnly =
    zio.aws.cloudfront.model.ParameterDefinition.wrap(buildAwsValue())
}
object ParameterDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ParameterDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ParameterDefinition =
      zio.aws.cloudfront.model.ParameterDefinition(name, definition.asEditable)
    def name: ParameterName
    def definition: zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly
    def getName: ZIO[Any, Nothing, ParameterName] = ZIO.succeed(name)
    def getDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly
    ] = ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ParameterDefinition
  ) extends zio.aws.cloudfront.model.ParameterDefinition.ReadOnly {
    override val name: ParameterName =
      zio.aws.cloudfront.model.primitives.ParameterName(impl.name())
    override val definition
        : zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly =
      zio.aws.cloudfront.model.ParameterDefinitionSchema.wrap(impl.definition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ParameterDefinition
  ): zio.aws.cloudfront.model.ParameterDefinition.ReadOnly = new Wrapper(impl)
}
