package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListConnectionGroupsResponse(
    nextMarker: Optional[String] = Optional.Absent,
    connectionGroups: Optional[
      Iterable[zio.aws.cloudfront.model.ConnectionGroupSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse = {
    import ListConnectionGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        connectionGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListConnectionGroupsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListConnectionGroupsResponse.wrap(buildAwsValue())
}
object ListConnectionGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListConnectionGroupsResponse =
      zio.aws.cloudfront.model.ListConnectionGroupsResponse(
        nextMarker.map(value => value),
        connectionGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def connectionGroups: Optional[
      List[zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getConnectionGroups: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("connectionGroups", connectionGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse
  ) extends zio.aws.cloudfront.model.ListConnectionGroupsResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val connectionGroups: Optional[
      List[zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.ConnectionGroupSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse
  ): zio.aws.cloudfront.model.ListConnectionGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
