package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConnectionGroupResponse(
    connectionGroup: Optional[zio.aws.cloudfront.model.ConnectionGroup] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupResponse = {
    import GetConnectionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupResponse
      .builder()
      .optionallyWith(connectionGroup.map(value => value.buildAwsValue()))(
        _.connectionGroup
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetConnectionGroupResponse.ReadOnly =
    zio.aws.cloudfront.model.GetConnectionGroupResponse.wrap(buildAwsValue())
}
object GetConnectionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetConnectionGroupResponse =
      zio.aws.cloudfront.model.GetConnectionGroupResponse(
        connectionGroup.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def connectionGroup
        : Optional[zio.aws.cloudfront.model.ConnectionGroup.ReadOnly]
    def eTag: Optional[String]
    def getConnectionGroup: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ConnectionGroup.ReadOnly
    ] = AwsError.unwrapOptionField("connectionGroup", connectionGroup)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupResponse
  ) extends zio.aws.cloudfront.model.GetConnectionGroupResponse.ReadOnly {
    override val connectionGroup
        : Optional[zio.aws.cloudfront.model.ConnectionGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionGroup())
        .map(value => zio.aws.cloudfront.model.ConnectionGroup.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupResponse
  ): zio.aws.cloudfront.model.GetConnectionGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
