package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConnectionGroupRequest(identifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupRequest = {
    import GetConnectionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupRequest
      .builder()
      .identifier(identifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetConnectionGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.GetConnectionGroupRequest.wrap(buildAwsValue())
}
object GetConnectionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetConnectionGroupRequest =
      zio.aws.cloudfront.model.GetConnectionGroupRequest(identifier)
    def identifier: String
    def getIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupRequest
  ) extends zio.aws.cloudfront.model.GetConnectionGroupRequest.ReadOnly {
    override val identifier: String = impl.identifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupRequest
  ): zio.aws.cloudfront.model.GetConnectionGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
