package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GeoRestrictionCustomization(
    restrictionType: zio.aws.cloudfront.model.GeoRestrictionType,
    locations: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GeoRestrictionCustomization = {
    import GeoRestrictionCustomization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GeoRestrictionCustomization
      .builder()
      .restrictionType(restrictionType.unwrap)
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.locations)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly =
    zio.aws.cloudfront.model.GeoRestrictionCustomization.wrap(buildAwsValue())
}
object GeoRestrictionCustomization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GeoRestrictionCustomization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GeoRestrictionCustomization =
      zio.aws.cloudfront.model.GeoRestrictionCustomization(
        restrictionType,
        locations.map(value => value)
      )
    def restrictionType: zio.aws.cloudfront.model.GeoRestrictionType
    def locations: Optional[List[String]]
    def getRestrictionType
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.GeoRestrictionType] =
      ZIO.succeed(restrictionType)
    def getLocations: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("locations", locations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GeoRestrictionCustomization
  ) extends zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly {
    override val restrictionType: zio.aws.cloudfront.model.GeoRestrictionType =
      zio.aws.cloudfront.model.GeoRestrictionType.wrap(impl.restrictionType())
    override val locations: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.locations())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GeoRestrictionCustomization
  ): zio.aws.cloudfront.model.GeoRestrictionCustomization.ReadOnly =
    new Wrapper(impl)
}
