package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DistributionResourceId(
    distributionId: Optional[String] = Optional.Absent,
    distributionTenantId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionResourceId = {
    import DistributionResourceId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionResourceId
      .builder()
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(
        distributionTenantId.map(value => value: java.lang.String)
      )(_.distributionTenantId)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionResourceId.ReadOnly =
    zio.aws.cloudfront.model.DistributionResourceId.wrap(buildAwsValue())
}
object DistributionResourceId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionResourceId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionResourceId =
      zio.aws.cloudfront.model.DistributionResourceId(
        distributionId.map(value => value),
        distributionTenantId.map(value => value)
      )
    def distributionId: Optional[String]
    def distributionTenantId: Optional[String]
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getDistributionTenantId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionTenantId", distributionTenantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionResourceId
  ) extends zio.aws.cloudfront.model.DistributionResourceId.ReadOnly {
    override val distributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionId())
      .map(value => value: String)
    override val distributionTenantId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionTenantId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionResourceId
  ): zio.aws.cloudfront.model.DistributionResourceId.ReadOnly = new Wrapper(
    impl
  )
}
