package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInvalidationForDistributionTenantResponse(
    location: Optional[String] = Optional.Absent,
    invalidation: Optional[zio.aws.cloudfront.model.Invalidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantResponse = {
    import CreateInvalidationForDistributionTenantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(invalidation.map(value => value.buildAwsValue()))(
        _.invalidation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse
      .wrap(buildAwsValue())
}
object CreateInvalidationForDistributionTenantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse =
      zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse(
        location.map(value => value),
        invalidation.map(value => value.asEditable)
      )
    def location: Optional[String]
    def invalidation: Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getInvalidation
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      AwsError.unwrapOptionField("invalidation", invalidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantResponse
  ) extends zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val invalidation
        : Optional[zio.aws.cloudfront.model.Invalidation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidation())
        .map(value => zio.aws.cloudfront.model.Invalidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantResponse
  ): zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantResponse.ReadOnly =
    new Wrapper(impl)
}
