package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateDistributionWebAclRequest(
    id: String,
    webACLArn: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AssociateDistributionWebAclRequest = {
    import AssociateDistributionWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AssociateDistributionWebAclRequest
      .builder()
      .id(id: java.lang.String)
      .webACLArn(webACLArn: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.AssociateDistributionWebAclRequest.ReadOnly =
    zio.aws.cloudfront.model.AssociateDistributionWebAclRequest
      .wrap(buildAwsValue())
}
object AssociateDistributionWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AssociateDistributionWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.AssociateDistributionWebAclRequest =
      zio.aws.cloudfront.model.AssociateDistributionWebAclRequest(
        id,
        webACLArn,
        ifMatch.map(value => value)
      )
    def id: String
    def webACLArn: String
    def ifMatch: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getWebACLArn: ZIO[Any, Nothing, String] = ZIO.succeed(webACLArn)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateDistributionWebAclRequest
  ) extends zio.aws.cloudfront.model.AssociateDistributionWebAclRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val webACLArn: String = impl.webACLArn(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateDistributionWebAclRequest
  ): zio.aws.cloudfront.model.AssociateDistributionWebAclRequest.ReadOnly =
    new Wrapper(impl)
}
