package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.ServerCertificateId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ViewerCertificate(
    cloudFrontDefaultCertificate: Optional[Boolean] = Optional.Absent,
    iamCertificateId: Optional[ServerCertificateId] = Optional.Absent,
    acmCertificateArn: Optional[String] = Optional.Absent,
    sslSupportMethod: Optional[zio.aws.cloudfront.model.SSLSupportMethod] =
      Optional.Absent,
    minimumProtocolVersion: Optional[
      zio.aws.cloudfront.model.MinimumProtocolVersion
    ] = Optional.Absent,
    certificate: Optional[String] = Optional.Absent,
    certificateSource: Optional[zio.aws.cloudfront.model.CertificateSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ViewerCertificate = {
    import ViewerCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
      .builder()
      .optionallyWith(
        cloudFrontDefaultCertificate.map(value => value: java.lang.Boolean)
      )(_.cloudFrontDefaultCertificate)
      .optionallyWith(
        iamCertificateId.map(value =>
          ServerCertificateId.unwrap(value): java.lang.String
        )
      )(_.iamCertificateId)
      .optionallyWith(acmCertificateArn.map(value => value: java.lang.String))(
        _.acmCertificateArn
      )
      .optionallyWith(sslSupportMethod.map(value => value.unwrap))(
        _.sslSupportMethod
      )
      .optionallyWith(minimumProtocolVersion.map(value => value.unwrap))(
        _.minimumProtocolVersion
      )
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .optionallyWith(certificateSource.map(value => value.unwrap))(
        _.certificateSource
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ViewerCertificate.ReadOnly =
    zio.aws.cloudfront.model.ViewerCertificate.wrap(buildAwsValue())
}
object ViewerCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ViewerCertificate =
      zio.aws.cloudfront.model.ViewerCertificate(
        cloudFrontDefaultCertificate.map(value => value),
        iamCertificateId.map(value => value),
        acmCertificateArn.map(value => value),
        sslSupportMethod.map(value => value),
        minimumProtocolVersion.map(value => value),
        certificate.map(value => value),
        certificateSource.map(value => value)
      )
    def cloudFrontDefaultCertificate: Optional[Boolean]
    def iamCertificateId: Optional[ServerCertificateId]
    def acmCertificateArn: Optional[String]
    def sslSupportMethod: Optional[zio.aws.cloudfront.model.SSLSupportMethod]
    def minimumProtocolVersion
        : Optional[zio.aws.cloudfront.model.MinimumProtocolVersion]
    def certificate: Optional[String]
    def certificateSource: Optional[zio.aws.cloudfront.model.CertificateSource]
    def getCloudFrontDefaultCertificate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "cloudFrontDefaultCertificate",
        cloudFrontDefaultCertificate
      )
    def getIamCertificateId: ZIO[Any, AwsError, ServerCertificateId] =
      AwsError.unwrapOptionField("iamCertificateId", iamCertificateId)
    def getAcmCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acmCertificateArn", acmCertificateArn)
    def getSslSupportMethod
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.SSLSupportMethod] =
      AwsError.unwrapOptionField("sslSupportMethod", sslSupportMethod)
    def getMinimumProtocolVersion
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.MinimumProtocolVersion] =
      AwsError.unwrapOptionField(
        "minimumProtocolVersion",
        minimumProtocolVersion
      )
    def getCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateSource
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CertificateSource] =
      AwsError.unwrapOptionField("certificateSource", certificateSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ) extends zio.aws.cloudfront.model.ViewerCertificate.ReadOnly {
    override val cloudFrontDefaultCertificate: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudFrontDefaultCertificate())
        .map(value => value: Boolean)
    override val iamCertificateId: Optional[ServerCertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamCertificateId())
        .map(value =>
          zio.aws.cloudfront.model.primitives.ServerCertificateId(value)
        )
    override val acmCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.acmCertificateArn())
      .map(value => value: String)
    override val sslSupportMethod
        : Optional[zio.aws.cloudfront.model.SSLSupportMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslSupportMethod())
        .map(value => zio.aws.cloudfront.model.SSLSupportMethod.wrap(value))
    override val minimumProtocolVersion
        : Optional[zio.aws.cloudfront.model.MinimumProtocolVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumProtocolVersion())
        .map(value =>
          zio.aws.cloudfront.model.MinimumProtocolVersion.wrap(value)
        )
    override val certificate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => value: String)
    override val certificateSource
        : Optional[zio.aws.cloudfront.model.CertificateSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateSource())
        .map(value => zio.aws.cloudfront.model.CertificateSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ViewerCertificate
  ): zio.aws.cloudfront.model.ViewerCertificate.ReadOnly = new Wrapper(impl)
}
