package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.{FunctionBlob, FunctionName}
import scala.jdk.CollectionConverters._
final case class UpdateFunctionRequest(
    name: FunctionName,
    ifMatch: String,
    functionConfig: zio.aws.cloudfront.model.FunctionConfig,
    functionCode: FunctionBlob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest = {
    import UpdateFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .functionConfig(functionConfig.buildAwsValue())
      .functionCode(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(functionCode.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateFunctionRequest.wrap(buildAwsValue())
}
object UpdateFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateFunctionRequest =
      zio.aws.cloudfront.model.UpdateFunctionRequest(
        name,
        ifMatch,
        functionConfig.asEditable,
        functionCode
      )
    def name: FunctionName
    def ifMatch: String
    def functionConfig: zio.aws.cloudfront.model.FunctionConfig.ReadOnly
    def functionCode: FunctionBlob
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
    def getFunctionConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FunctionConfig.ReadOnly] =
      ZIO.succeed(functionConfig)
    def getFunctionCode: ZIO[Any, Nothing, FunctionBlob] =
      ZIO.succeed(functionCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest
  ) extends zio.aws.cloudfront.model.UpdateFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val ifMatch: String = impl.ifMatch(): String
    override val functionConfig
        : zio.aws.cloudfront.model.FunctionConfig.ReadOnly =
      zio.aws.cloudfront.model.FunctionConfig.wrap(impl.functionConfig())
    override val functionCode: FunctionBlob =
      zio.aws.cloudfront.model.primitives.FunctionBlob(
        zio.Chunk.fromArray(impl.functionCode().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest
  ): zio.aws.cloudfront.model.UpdateFunctionRequest.ReadOnly = new Wrapper(impl)
}
