package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainAssociationRequest(
    domain: String,
    targetResource: zio.aws.cloudfront.model.DistributionResourceId,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationRequest = {
    import UpdateDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationRequest
      .builder()
      .domain(domain: java.lang.String)
      .targetResource(targetResource.buildAwsValue())
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateDomainAssociationRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateDomainAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDomainAssociationRequest =
      zio.aws.cloudfront.model.UpdateDomainAssociationRequest(
        domain,
        targetResource.asEditable,
        ifMatch.map(value => value)
      )
    def domain: String
    def targetResource: zio.aws.cloudfront.model.DistributionResourceId.ReadOnly
    def ifMatch: Optional[String]
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getTargetResource: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionResourceId.ReadOnly
    ] = ZIO.succeed(targetResource)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationRequest
  ) extends zio.aws.cloudfront.model.UpdateDomainAssociationRequest.ReadOnly {
    override val domain: String = impl.domain(): String
    override val targetResource
        : zio.aws.cloudfront.model.DistributionResourceId.ReadOnly =
      zio.aws.cloudfront.model.DistributionResourceId
        .wrap(impl.targetResource())
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDomainAssociationRequest
  ): zio.aws.cloudfront.model.UpdateDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
