package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionTenantResponse(
    distributionTenant: Optional[zio.aws.cloudfront.model.DistributionTenant] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantResponse = {
    import UpdateDistributionTenantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantResponse
      .builder()
      .optionallyWith(distributionTenant.map(value => value.buildAwsValue()))(
        _.distributionTenant
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateDistributionTenantResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateDistributionTenantResponse
      .wrap(buildAwsValue())
}
object UpdateDistributionTenantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDistributionTenantResponse =
      zio.aws.cloudfront.model.UpdateDistributionTenantResponse(
        distributionTenant.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def distributionTenant
        : Optional[zio.aws.cloudfront.model.DistributionTenant.ReadOnly]
    def eTag: Optional[String]
    def getDistributionTenant: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionTenant.ReadOnly
    ] = AwsError.unwrapOptionField("distributionTenant", distributionTenant)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantResponse
  ) extends zio.aws.cloudfront.model.UpdateDistributionTenantResponse.ReadOnly {
    override val distributionTenant
        : Optional[zio.aws.cloudfront.model.DistributionTenant.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionTenant())
        .map(value => zio.aws.cloudfront.model.DistributionTenant.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionTenantResponse
  ): zio.aws.cloudfront.model.UpdateDistributionTenantResponse.ReadOnly =
    new Wrapper(impl)
}
