package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionTenantsRequest(
    associationFilter: Optional[
      zio.aws.cloudfront.model.DistributionTenantAssociationFilter
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest = {
    import ListDistributionTenantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest
      .builder()
      .optionallyWith(associationFilter.map(value => value.buildAwsValue()))(
        _.associationFilter
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionTenantsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionTenantsRequest
      .wrap(buildAwsValue())
}
object ListDistributionTenantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDistributionTenantsRequest =
      zio.aws.cloudfront.model.ListDistributionTenantsRequest(
        associationFilter.map(value => value.asEditable),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def associationFilter: Optional[
      zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly
    ]
    def marker: Optional[String]
    def maxItems: Optional[Integer]
    def getAssociationFilter: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("associationFilter", associationFilter)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest
  ) extends zio.aws.cloudfront.model.ListDistributionTenantsRequest.ReadOnly {
    override val associationFilter: Optional[
      zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationFilter())
      .map(value =>
        zio.aws.cloudfront.model.DistributionTenantAssociationFilter.wrap(value)
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsRequest
  ): zio.aws.cloudfront.model.ListDistributionTenantsRequest.ReadOnly =
    new Wrapper(impl)
}
