package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ImportSourceType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ImportSourceType
}
object ImportSourceType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ImportSourceType
  ): zio.aws.cloudfront.model.ImportSourceType = value match {
    case software.amazon.awssdk.services.cloudfront.model.ImportSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ImportSourceType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ImportSourceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ImportSourceType =
      software.amazon.awssdk.services.cloudfront.model.ImportSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.cloudfront.model.ImportSourceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ImportSourceType =
      software.amazon.awssdk.services.cloudfront.model.ImportSourceType.S3
  }
}
