package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.FunctionName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFunctionRequest(
    name: FunctionName,
    stage: Optional[zio.aws.cloudfront.model.FunctionStage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest = {
    import GetFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.GetFunctionRequest.wrap(buildAwsValue())
}
object GetFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetFunctionRequest =
      zio.aws.cloudfront.model
        .GetFunctionRequest(name, stage.map(value => value))
    def name: FunctionName
    def stage: Optional[zio.aws.cloudfront.model.FunctionStage]
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ) extends zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val stage: Optional[zio.aws.cloudfront.model.FunctionStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ): zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly = new Wrapper(impl)
}
