package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConnectionGroupByRoutingEndpointRequest(
    routingEndpoint: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest = {
    import GetConnectionGroupByRoutingEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest
      .builder()
      .routingEndpoint(routingEndpoint: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest.ReadOnly =
    zio.aws.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest
      .wrap(buildAwsValue())
}
object GetConnectionGroupByRoutingEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest =
      zio.aws.cloudfront.model
        .GetConnectionGroupByRoutingEndpointRequest(routingEndpoint)
    def routingEndpoint: String
    def getRoutingEndpoint: ZIO[Any, Nothing, String] =
      ZIO.succeed(routingEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest
  ) extends zio.aws.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest.ReadOnly {
    override val routingEndpoint: String = impl.routingEndpoint(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest
  ): zio.aws.cloudfront.model.GetConnectionGroupByRoutingEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
