package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateDistributionTenantWebAclResponse(
    id: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclResponse = {
    import DisassociateDistributionTenantWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse.ReadOnly =
    zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse
      .wrap(buildAwsValue())
}
object DisassociateDistributionTenantWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse =
      zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse(
        id.map(value => value),
        eTag.map(value => value)
      )
    def id: Optional[String]
    def eTag: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclResponse
  ) extends zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DisassociateDistributionTenantWebAclResponse
  ): zio.aws.cloudfront.model.DisassociateDistributionTenantWebAclResponse.ReadOnly =
    new Wrapper(impl)
}
