package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.FunctionName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFunctionRequest(
    name: FunctionName,
    stage: Optional[zio.aws.cloudfront.model.FunctionStage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest = {
    import DescribeFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DescribeFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.DescribeFunctionRequest.wrap(buildAwsValue())
}
object DescribeFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DescribeFunctionRequest =
      zio.aws.cloudfront.model
        .DescribeFunctionRequest(name, stage.map(value => value))
    def name: FunctionName
    def stage: Optional[zio.aws.cloudfront.model.FunctionStage]
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest
  ) extends zio.aws.cloudfront.model.DescribeFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val stage: Optional[zio.aws.cloudfront.model.FunctionStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest
  ): zio.aws.cloudfront.model.DescribeFunctionRequest.ReadOnly = new Wrapper(
    impl
  )
}
