package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateInvalidationForDistributionTenantRequest(
    id: String,
    invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantRequest = {
    import CreateInvalidationForDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantRequest
      .builder()
      .id(id: java.lang.String)
      .invalidationBatch(invalidationBatch.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest
      .wrap(buildAwsValue())
}
object CreateInvalidationForDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest =
      zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest(
        id,
        invalidationBatch.asEditable
      )
    def id: String
    def invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getInvalidationBatch: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    ] = ZIO.succeed(invalidationBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val invalidationBatch
        : zio.aws.cloudfront.model.InvalidationBatch.ReadOnly =
      zio.aws.cloudfront.model.InvalidationBatch.wrap(impl.invalidationBatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationForDistributionTenantRequest
  ): zio.aws.cloudfront.model.CreateInvalidationForDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
