package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Certificate(arn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Certificate
      .builder()
      .arn(arn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Certificate.ReadOnly =
    zio.aws.cloudfront.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Certificate =
      zio.aws.cloudfront.model.Certificate(arn)
    def arn: String
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Certificate
  ) extends zio.aws.cloudfront.model.Certificate.ReadOnly {
    override val arn: String = impl.arn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Certificate
  ): zio.aws.cloudfront.model.Certificate.ReadOnly = new Wrapper(impl)
}
