package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.{ParameterValue, ParameterName}
import scala.jdk.CollectionConverters._
final case class Parameter(name: ParameterName, value: ParameterValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Parameter
      .builder()
      .name(ParameterName.unwrap(name): java.lang.String)
      .value(ParameterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Parameter.ReadOnly =
    zio.aws.cloudfront.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Parameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Parameter =
      zio.aws.cloudfront.model.Parameter(name, value)
    def name: ParameterName
    def value: ParameterValue
    def getName: ZIO[Any, Nothing, ParameterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Parameter
  ) extends zio.aws.cloudfront.model.Parameter.ReadOnly {
    override val name: ParameterName =
      zio.aws.cloudfront.model.primitives.ParameterName(impl.name())
    override val value: ParameterValue =
      zio.aws.cloudfront.model.primitives.ParameterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Parameter
  ): zio.aws.cloudfront.model.Parameter.ReadOnly = new Wrapper(impl)
}
