package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByConnectionModeResponse(
    distributionList: Optional[zio.aws.cloudfront.model.DistributionList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse = {
    import ListDistributionsByConnectionModeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse
      .builder()
      .optionallyWith(distributionList.map(value => value.buildAwsValue()))(
        _.distributionList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse
      .wrap(buildAwsValue())
}
object ListDistributionsByConnectionModeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse =
      zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse(
        distributionList.map(value => value.asEditable)
      )
    def distributionList
        : Optional[zio.aws.cloudfront.model.DistributionList.ReadOnly]
    def getDistributionList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionList.ReadOnly
    ] = AwsError.unwrapOptionField("distributionList", distributionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse
  ) extends zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse.ReadOnly {
    override val distributionList
        : Optional[zio.aws.cloudfront.model.DistributionList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionList())
        .map(value => zio.aws.cloudfront.model.DistributionList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse
  ): zio.aws.cloudfront.model.ListDistributionsByConnectionModeResponse.ReadOnly =
    new Wrapper(impl)
}
