package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByConnectionModeRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[Integer] = Optional.Absent,
    connectionMode: zio.aws.cloudfront.model.ConnectionMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest = {
    import ListDistributionsByConnectionModeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.Integer))(
        _.maxItems
      )
      .connectionMode(connectionMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByConnectionModeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest =
      zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        connectionMode
      )
    def marker: Optional[String]
    def maxItems: Optional[Integer]
    def connectionMode: zio.aws.cloudfront.model.ConnectionMode
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getConnectionMode
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.ConnectionMode] =
      ZIO.succeed(connectionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: Integer)
    override val connectionMode: zio.aws.cloudfront.model.ConnectionMode =
      zio.aws.cloudfront.model.ConnectionMode.wrap(impl.connectionMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest
  ): zio.aws.cloudfront.model.ListDistributionsByConnectionModeRequest.ReadOnly =
    new Wrapper(impl)
}
