package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRealtimeLogConfigRequest(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest = {
    import GetRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.GetRealtimeLogConfigRequest.wrap(buildAwsValue())
}
object GetRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.GetRealtimeLogConfigRequest(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.GetRealtimeLogConfigRequest.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.GetRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
