package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInvalidationForDistributionTenantRequest(
    distributionTenantId: String,
    id: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest = {
    import GetInvalidationForDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest
      .builder()
      .distributionTenantId(distributionTenantId: java.lang.String)
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetInvalidationForDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.GetInvalidationForDistributionTenantRequest
      .wrap(buildAwsValue())
}
object GetInvalidationForDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetInvalidationForDistributionTenantRequest =
      zio.aws.cloudfront.model
        .GetInvalidationForDistributionTenantRequest(distributionTenantId, id)
    def distributionTenantId: String
    def id: String
    def getDistributionTenantId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionTenantId)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.GetInvalidationForDistributionTenantRequest.ReadOnly {
    override val distributionTenantId: String =
      impl.distributionTenantId(): String
    override val id: String = impl.id(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationForDistributionTenantRequest
  ): zio.aws.cloudfront.model.GetInvalidationForDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
