package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionTenantResponse(
    distributionTenant: Optional[zio.aws.cloudfront.model.DistributionTenant] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetDistributionTenantResponse = {
    import GetDistributionTenantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetDistributionTenantResponse
      .builder()
      .optionallyWith(distributionTenant.map(value => value.buildAwsValue()))(
        _.distributionTenant
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetDistributionTenantResponse.ReadOnly =
    zio.aws.cloudfront.model.GetDistributionTenantResponse.wrap(buildAwsValue())
}
object GetDistributionTenantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetDistributionTenantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetDistributionTenantResponse =
      zio.aws.cloudfront.model.GetDistributionTenantResponse(
        distributionTenant.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def distributionTenant
        : Optional[zio.aws.cloudfront.model.DistributionTenant.ReadOnly]
    def eTag: Optional[String]
    def getDistributionTenant: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionTenant.ReadOnly
    ] = AwsError.unwrapOptionField("distributionTenant", distributionTenant)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionTenantResponse
  ) extends zio.aws.cloudfront.model.GetDistributionTenantResponse.ReadOnly {
    override val distributionTenant
        : Optional[zio.aws.cloudfront.model.DistributionTenant.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionTenant())
        .map(value => zio.aws.cloudfront.model.DistributionTenant.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionTenantResponse
  ): zio.aws.cloudfront.model.GetDistributionTenantResponse.ReadOnly =
    new Wrapper(impl)
}
