package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainResult(
    domain: String,
    status: Optional[zio.aws.cloudfront.model.DomainStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DomainResult = {
    import DomainResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DomainResult
      .builder()
      .domain(domain: java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DomainResult.ReadOnly =
    zio.aws.cloudfront.model.DomainResult.wrap(buildAwsValue())
}
object DomainResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DomainResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DomainResult =
      zio.aws.cloudfront.model.DomainResult(domain, status.map(value => value))
    def domain: String
    def status: Optional[zio.aws.cloudfront.model.DomainStatus]
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getStatus: ZIO[Any, AwsError, zio.aws.cloudfront.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainResult
  ) extends zio.aws.cloudfront.model.DomainResult.ReadOnly {
    override val domain: String = impl.domain(): String
    override val status: Optional[zio.aws.cloudfront.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudfront.model.DomainStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainResult
  ): zio.aws.cloudfront.model.DomainResult.ReadOnly = new Wrapper(impl)
}
