package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DistributionTenant(
    id: Optional[String] = Optional.Absent,
    distributionId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    domains: Optional[Iterable[zio.aws.cloudfront.model.DomainResult]] =
      Optional.Absent,
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent,
    customizations: Optional[zio.aws.cloudfront.model.Customizations] =
      Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudfront.model.Parameter]] =
      Optional.Absent,
    connectionGroupId: Optional[String] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionTenant = {
    import DistributionTenant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionTenant
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .optionallyWith(customizations.map(value => value.buildAwsValue()))(
        _.customizations
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(connectionGroupId.map(value => value: java.lang.String))(
        _.connectionGroupId
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionTenant.ReadOnly =
    zio.aws.cloudfront.model.DistributionTenant.wrap(buildAwsValue())
}
object DistributionTenant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionTenant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionTenant =
      zio.aws.cloudfront.model.DistributionTenant(
        id.map(value => value),
        distributionId.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        domains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value.asEditable),
        customizations.map(value => value.asEditable),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionGroupId.map(value => value),
        createdTime.map(value => value),
        lastModifiedTime.map(value => value),
        enabled.map(value => value),
        status.map(value => value)
      )
    def id: Optional[String]
    def distributionId: Optional[String]
    def name: Optional[String]
    def arn: Optional[String]
    def domains: Optional[List[zio.aws.cloudfront.model.DomainResult.ReadOnly]]
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly]
    def parameters: Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]]
    def connectionGroupId: Optional[String]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def enabled: Optional[Boolean]
    def status: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDomains: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.DomainResult.ReadOnly
    ]] = AwsError.unwrapOptionField("domains", domains)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
    def getCustomizations
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Customizations.ReadOnly] =
      AwsError.unwrapOptionField("customizations", customizations)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getConnectionGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionGroupId", connectionGroupId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenant
  ) extends zio.aws.cloudfront.model.DistributionTenant.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val distributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val domains
        : Optional[List[zio.aws.cloudfront.model.DomainResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.DomainResult.wrap(item)
          }.toList
        )
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
    override val customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizations())
        .map(value => zio.aws.cloudfront.model.Customizations.wrap(value))
    override val parameters
        : Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.Parameter.wrap(item)
          }.toList
        )
    override val connectionGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroupId())
      .map(value => value: String)
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenant
  ): zio.aws.cloudfront.model.DistributionTenant.ReadOnly = new Wrapper(impl)
}
