package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionMode {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ConnectionMode
}
object ConnectionMode {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ConnectionMode
  ): zio.aws.cloudfront.model.ConnectionMode = value match {
    case software.amazon.awssdk.services.cloudfront.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ConnectionMode.DIRECT =>
      val r = direct
      r
    case software.amazon.awssdk.services.cloudfront.model.ConnectionMode.TENANT_ONLY =>
      val r = `tenant-only`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ConnectionMode =
      software.amazon.awssdk.services.cloudfront.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object direct extends zio.aws.cloudfront.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ConnectionMode =
      software.amazon.awssdk.services.cloudfront.model.ConnectionMode.DIRECT
  }
  case object `tenant-only` extends zio.aws.cloudfront.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ConnectionMode =
      software.amazon.awssdk.services.cloudfront.model.ConnectionMode.TENANT_ONLY
  }
}
