package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CertificateTransparencyLoggingPreference {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference
}
object CertificateTransparencyLoggingPreference {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference
  ): zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference =
    value match {
      case software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.ENABLED =>
        val r = enabled
        r
      case software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.DISABLED =>
        val r = disabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled
      extends zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.ENABLED
  }
  case object disabled
      extends zio.aws.cloudfront.model.CertificateTransparencyLoggingPreference {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference =
      software.amazon.awssdk.services.cloudfront.model.CertificateTransparencyLoggingPreference.DISABLED
  }
}
