package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Origin(
    id: String,
    domainName: String,
    originPath: Optional[String] = Optional.Absent,
    customHeaders: Optional[zio.aws.cloudfront.model.CustomHeaders] =
      Optional.Absent,
    s3OriginConfig: Optional[zio.aws.cloudfront.model.S3OriginConfig] =
      Optional.Absent,
    customOriginConfig: Optional[zio.aws.cloudfront.model.CustomOriginConfig] =
      Optional.Absent,
    vpcOriginConfig: Optional[zio.aws.cloudfront.model.VpcOriginConfig] =
      Optional.Absent,
    connectionAttempts: Optional[Integer] = Optional.Absent,
    connectionTimeout: Optional[Integer] = Optional.Absent,
    originShield: Optional[zio.aws.cloudfront.model.OriginShield] =
      Optional.Absent,
    originAccessControlId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Origin = {
    import Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Origin
      .builder()
      .id(id: java.lang.String)
      .domainName(domainName: java.lang.String)
      .optionallyWith(originPath.map(value => value: java.lang.String))(
        _.originPath
      )
      .optionallyWith(customHeaders.map(value => value.buildAwsValue()))(
        _.customHeaders
      )
      .optionallyWith(s3OriginConfig.map(value => value.buildAwsValue()))(
        _.s3OriginConfig
      )
      .optionallyWith(customOriginConfig.map(value => value.buildAwsValue()))(
        _.customOriginConfig
      )
      .optionallyWith(vpcOriginConfig.map(value => value.buildAwsValue()))(
        _.vpcOriginConfig
      )
      .optionallyWith(
        connectionAttempts.map(value => value: java.lang.Integer)
      )(_.connectionAttempts)
      .optionallyWith(connectionTimeout.map(value => value: java.lang.Integer))(
        _.connectionTimeout
      )
      .optionallyWith(originShield.map(value => value.buildAwsValue()))(
        _.originShield
      )
      .optionallyWith(
        originAccessControlId.map(value => value: java.lang.String)
      )(_.originAccessControlId)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Origin.ReadOnly =
    zio.aws.cloudfront.model.Origin.wrap(buildAwsValue())
}
object Origin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudfront.model.Origin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Origin =
      zio.aws.cloudfront.model.Origin(
        id,
        domainName,
        originPath.map(value => value),
        customHeaders.map(value => value.asEditable),
        s3OriginConfig.map(value => value.asEditable),
        customOriginConfig.map(value => value.asEditable),
        vpcOriginConfig.map(value => value.asEditable),
        connectionAttempts.map(value => value),
        connectionTimeout.map(value => value),
        originShield.map(value => value.asEditable),
        originAccessControlId.map(value => value)
      )
    def id: String
    def domainName: String
    def originPath: Optional[String]
    def customHeaders: Optional[zio.aws.cloudfront.model.CustomHeaders.ReadOnly]
    def s3OriginConfig
        : Optional[zio.aws.cloudfront.model.S3OriginConfig.ReadOnly]
    def customOriginConfig
        : Optional[zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly]
    def vpcOriginConfig
        : Optional[zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly]
    def connectionAttempts: Optional[Integer]
    def connectionTimeout: Optional[Integer]
    def originShield: Optional[zio.aws.cloudfront.model.OriginShield.ReadOnly]
    def originAccessControlId: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getOriginPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originPath", originPath)
    def getCustomHeaders
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CustomHeaders.ReadOnly] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getS3OriginConfig
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.S3OriginConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3OriginConfig", s3OriginConfig)
    def getCustomOriginConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly
    ] = AwsError.unwrapOptionField("customOriginConfig", customOriginConfig)
    def getVpcOriginConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOriginConfig", vpcOriginConfig)
    def getConnectionAttempts: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("connectionAttempts", connectionAttempts)
    def getConnectionTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("connectionTimeout", connectionTimeout)
    def getOriginShield
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginShield.ReadOnly] =
      AwsError.unwrapOptionField("originShield", originShield)
    def getOriginAccessControlId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originAccessControlId", originAccessControlId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Origin
  ) extends zio.aws.cloudfront.model.Origin.ReadOnly {
    override val id: String = impl.id(): String
    override val domainName: String = impl.domainName(): String
    override val originPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originPath())
      .map(value => value: String)
    override val customHeaders
        : Optional[zio.aws.cloudfront.model.CustomHeaders.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customHeaders())
        .map(value => zio.aws.cloudfront.model.CustomHeaders.wrap(value))
    override val s3OriginConfig
        : Optional[zio.aws.cloudfront.model.S3OriginConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3OriginConfig())
        .map(value => zio.aws.cloudfront.model.S3OriginConfig.wrap(value))
    override val customOriginConfig
        : Optional[zio.aws.cloudfront.model.CustomOriginConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customOriginConfig())
        .map(value => zio.aws.cloudfront.model.CustomOriginConfig.wrap(value))
    override val vpcOriginConfig
        : Optional[zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOriginConfig())
        .map(value => zio.aws.cloudfront.model.VpcOriginConfig.wrap(value))
    override val connectionAttempts: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionAttempts())
      .map(value => value: Integer)
    override val connectionTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionTimeout())
      .map(value => value: Integer)
    override val originShield
        : Optional[zio.aws.cloudfront.model.OriginShield.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originShield())
        .map(value => zio.aws.cloudfront.model.OriginShield.wrap(value))
    override val originAccessControlId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originAccessControlId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Origin
  ): zio.aws.cloudfront.model.Origin.ReadOnly = new Wrapper(impl)
}
