package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcOriginRequest(id: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest = {
    import DeleteVpcOriginRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest
      .builder()
      .id(id: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteVpcOriginRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteVpcOriginRequest.wrap(buildAwsValue())
}
object DeleteVpcOriginRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteVpcOriginRequest =
      zio.aws.cloudfront.model.DeleteVpcOriginRequest(id, ifMatch)
    def id: String
    def ifMatch: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest
  ) extends zio.aws.cloudfront.model.DeleteVpcOriginRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest
  ): zio.aws.cloudfront.model.DeleteVpcOriginRequest.ReadOnly = new Wrapper(
    impl
  )
}
