package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CachePolicyHeadersConfig(
    headerBehavior: zio.aws.cloudfront.model.CachePolicyHeaderBehavior,
    headers: Optional[zio.aws.cloudfront.model.Headers] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig = {
    import CachePolicyHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig
      .builder()
      .headerBehavior(headerBehavior.unwrap)
      .optionallyWith(headers.map(value => value.buildAwsValue()))(_.headers)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.CachePolicyHeadersConfig.wrap(buildAwsValue())
}
object CachePolicyHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachePolicyHeadersConfig =
      zio.aws.cloudfront.model.CachePolicyHeadersConfig(
        headerBehavior,
        headers.map(value => value.asEditable)
      )
    def headerBehavior: zio.aws.cloudfront.model.CachePolicyHeaderBehavior
    def headers: Optional[zio.aws.cloudfront.model.Headers.ReadOnly]
    def getHeaderBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyHeaderBehavior
    ] = ZIO.succeed(headerBehavior)
    def getHeaders
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Headers.ReadOnly] =
      AwsError.unwrapOptionField("headers", headers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig
  ) extends zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly {
    override val headerBehavior
        : zio.aws.cloudfront.model.CachePolicyHeaderBehavior =
      zio.aws.cloudfront.model.CachePolicyHeaderBehavior
        .wrap(impl.headerBehavior())
    override val headers: Optional[zio.aws.cloudfront.model.Headers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value => zio.aws.cloudfront.model.Headers.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyHeadersConfig
  ): zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly = new Wrapper(
    impl
  )
}
