package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VpcOriginSummary(
    id: String,
    name: String,
    status: String,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp,
    arn: String,
    originEndpointArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary = {
    import VpcOriginSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary
      .builder()
      .id(id: java.lang.String)
      .name(name: java.lang.String)
      .status(status: java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .arn(arn: java.lang.String)
      .originEndpointArn(originEndpointArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.VpcOriginSummary.ReadOnly =
    zio.aws.cloudfront.model.VpcOriginSummary.wrap(buildAwsValue())
}
object VpcOriginSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VpcOriginSummary =
      zio.aws.cloudfront.model.VpcOriginSummary(
        id,
        name,
        status,
        createdTime,
        lastModifiedTime,
        arn,
        originEndpointArn
      )
    def id: String
    def name: String
    def status: String
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def arn: String
    def originEndpointArn: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getOriginEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(originEndpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary
  ) extends zio.aws.cloudfront.model.VpcOriginSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val name: String = impl.name(): String
    override val status: String = impl.status(): String
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val arn: String = impl.arn(): String
    override val originEndpointArn: String = impl.originEndpointArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginSummary
  ): zio.aws.cloudfront.model.VpcOriginSummary.ReadOnly = new Wrapper(impl)
}
