package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcOriginEndpointConfig(
    name: String,
    arn: String,
    httpPort: Integer,
    httpsPort: Integer,
    originProtocolPolicy: zio.aws.cloudfront.model.OriginProtocolPolicy,
    originSslProtocols: Optional[zio.aws.cloudfront.model.OriginSslProtocols] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig = {
    import VpcOriginEndpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig
      .builder()
      .name(name: java.lang.String)
      .arn(arn: java.lang.String)
      .httpPort(httpPort: java.lang.Integer)
      .httpsPort(httpsPort: java.lang.Integer)
      .originProtocolPolicy(originProtocolPolicy.unwrap)
      .optionallyWith(originSslProtocols.map(value => value.buildAwsValue()))(
        _.originSslProtocols
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly =
    zio.aws.cloudfront.model.VpcOriginEndpointConfig.wrap(buildAwsValue())
}
object VpcOriginEndpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VpcOriginEndpointConfig =
      zio.aws.cloudfront.model.VpcOriginEndpointConfig(
        name,
        arn,
        httpPort,
        httpsPort,
        originProtocolPolicy,
        originSslProtocols.map(value => value.asEditable)
      )
    def name: String
    def arn: String
    def httpPort: Integer
    def httpsPort: Integer
    def originProtocolPolicy: zio.aws.cloudfront.model.OriginProtocolPolicy
    def originSslProtocols
        : Optional[zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getHttpPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(httpPort)
    def getHttpsPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(httpsPort)
    def getOriginProtocolPolicy
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.OriginProtocolPolicy] =
      ZIO.succeed(originProtocolPolicy)
    def getOriginSslProtocols: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly
    ] = AwsError.unwrapOptionField("originSslProtocols", originSslProtocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig
  ) extends zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: String = impl.arn(): String
    override val httpPort: Integer = impl.httpPort(): Integer
    override val httpsPort: Integer = impl.httpsPort(): Integer
    override val originProtocolPolicy
        : zio.aws.cloudfront.model.OriginProtocolPolicy =
      zio.aws.cloudfront.model.OriginProtocolPolicy
        .wrap(impl.originProtocolPolicy())
    override val originSslProtocols
        : Optional[zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originSslProtocols())
        .map(value => zio.aws.cloudfront.model.OriginSslProtocols.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginEndpointConfig
  ): zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly = new Wrapper(
    impl
  )
}
