package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PublicKey(
    id: String,
    createdTime: Timestamp,
    publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublicKey = {
    import PublicKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublicKey
      .builder()
      .id(id: java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .publicKeyConfig(publicKeyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublicKey.ReadOnly =
    zio.aws.cloudfront.model.PublicKey.wrap(buildAwsValue())
}
object PublicKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublicKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublicKey =
      zio.aws.cloudfront.model
        .PublicKey(id, createdTime, publicKeyConfig.asEditable)
    def id: String
    def createdTime: Timestamp
    def publicKeyConfig: zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getPublicKeyConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly] =
      ZIO.succeed(publicKeyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKey
  ) extends zio.aws.cloudfront.model.PublicKey.ReadOnly {
    override val id: String = impl.id(): String
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val publicKeyConfig
        : zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly =
      zio.aws.cloudfront.model.PublicKeyConfig.wrap(impl.publicKeyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKey
  ): zio.aws.cloudfront.model.PublicKey.ReadOnly = new Wrapper(impl)
}
