package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyValueStoreAssociations(
    quantity: Integer,
    items: Optional[
      Iterable[zio.aws.cloudfront.model.KeyValueStoreAssociation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociations = {
    import KeyValueStoreAssociations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociations
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly =
    zio.aws.cloudfront.model.KeyValueStoreAssociations.wrap(buildAwsValue())
}
object KeyValueStoreAssociations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyValueStoreAssociations =
      zio.aws.cloudfront.model.KeyValueStoreAssociations(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Optional[
      List[zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly]
    ]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociations
  ) extends zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[
      List[zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.KeyValueStoreAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociations
  ): zio.aws.cloudfront.model.KeyValueStoreAssociations.ReadOnly = new Wrapper(
    impl
  )
}
