package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcOriginResponse(
    vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginResponse = {
    import CreateVpcOriginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginResponse
      .builder()
      .optionallyWith(vpcOrigin.map(value => value.buildAwsValue()))(
        _.vpcOrigin
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateVpcOriginResponse.wrap(buildAwsValue())
}
object CreateVpcOriginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateVpcOriginResponse =
      zio.aws.cloudfront.model.CreateVpcOriginResponse(
        vpcOrigin.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getVpcOrigin
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      AwsError.unwrapOptionField("vpcOrigin", vpcOrigin)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginResponse
  ) extends zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly {
    override val vpcOrigin
        : Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOrigin())
        .map(value => zio.aws.cloudfront.model.VpcOrigin.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginResponse
  ): zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly = new Wrapper(
    impl
  )
}
