package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateRealtimeLogConfigRequest(
    endPoints: Iterable[zio.aws.cloudfront.model.EndPoint],
    fields: Iterable[String],
    name: String,
    samplingRate: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest = {
    import CreateRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest
      .builder()
      .endPoints(endPoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .fields(fields.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .name(name: java.lang.String)
      .samplingRate(samplingRate: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest
      .wrap(buildAwsValue())
}
object CreateRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest(
        endPoints.map { item =>
          item.asEditable
        },
        fields,
        name,
        samplingRate
      )
    def endPoints: List[zio.aws.cloudfront.model.EndPoint.ReadOnly]
    def fields: List[String]
    def name: String
    def samplingRate: Long
    def getEndPoints
        : ZIO[Any, Nothing, List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] =
      ZIO.succeed(endPoints)
    def getFields: ZIO[Any, Nothing, List[String]] = ZIO.succeed(fields)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSamplingRate: ZIO[Any, Nothing, Long] = ZIO.succeed(samplingRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest.ReadOnly {
    override val endPoints: List[zio.aws.cloudfront.model.EndPoint.ReadOnly] =
      impl
        .endPoints()
        .asScala
        .map { item =>
          zio.aws.cloudfront.model.EndPoint.wrap(item)
        }
        .toList
    override val fields: List[String] = impl
      .fields()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val name: String = impl.name(): String
    override val samplingRate: Long = impl.samplingRate(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.CreateRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
