package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WebAclCustomization(
    action: zio.aws.cloudfront.model.CustomizationActionType,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.WebAclCustomization = {
    import WebAclCustomization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.WebAclCustomization
      .builder()
      .action(action.unwrap)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.WebAclCustomization.ReadOnly =
    zio.aws.cloudfront.model.WebAclCustomization.wrap(buildAwsValue())
}
object WebAclCustomization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.WebAclCustomization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.WebAclCustomization =
      zio.aws.cloudfront.model
        .WebAclCustomization(action, arn.map(value => value))
    def action: zio.aws.cloudfront.model.CustomizationActionType
    def arn: Optional[String]
    def getAction
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.CustomizationActionType] =
      ZIO.succeed(action)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.WebAclCustomization
  ) extends zio.aws.cloudfront.model.WebAclCustomization.ReadOnly {
    override val action: zio.aws.cloudfront.model.CustomizationActionType =
      zio.aws.cloudfront.model.CustomizationActionType.wrap(impl.action())
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.WebAclCustomization
  ): zio.aws.cloudfront.model.WebAclCustomization.ReadOnly = new Wrapper(impl)
}
